/**
* \file: device_metadata.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef AAM_MODEL_DEVICE_METADATA_H
#define AAM_MODEL_DEVICE_METADATA_H

#include <stdlib.h>
#include <stdbool.h>

#include "model/device.h"

// metadata structures might be extended by additional attributes by certain backends. device_metadata_flexible_new
// can be used to create such an extended metadata structure. A special "free" function must be passed which is used by
// device_metadata_free to remove the metadata structure from the memory.

// The definition  of a function used by device_metadata_free to remove the metadata structure from memory.
typedef void (*device_metadata_free_func_t)(device_metadata_t *metadata);

//creates a minimal metadata structure
device_metadata_t *device_metadata_new(const char *device_type, const char *identifier);

//creates an extended metadata structure
device_metadata_t *device_metadata_flexible_new(const char *device_type, const char *identifier,
		size_t metadata_size, device_metadata_free_func_t free_func);

//removes minimal and extended metadata structures from memory
void device_metadata_free(device_t *device);

//get functions to access the attributes of the minimal metadata structure
const char *device_metadata_get_device_type(device_t *device);

const char *device_metadata_get_device_identifier(device_t *device);

#endif
